package gov.va.med.mhv.vitals.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="BLOOD_PRESSURE_READINGS")
public class BloodPressureReading implements Serializable{
	
	private static final long serialVersionUID = 477845185987661229L;

	@Id
	@Column(name="BLOOD_PRESSURE_ID_SEQ")
	@GeneratedValue(strategy=GenerationType.AUTO)
	private Long id;
	
	@Column(name="OPLOCK")
	private Integer oplock;
	
	@Column(name="DIASTOLIC")
	private Integer diastolic;
	
	@Column(name="COMMENTS")
	private String comments;
	
	@Column(name="READING")
	@Temporal(TemporalType.TIMESTAMP)
	private Date reading;
	
	@Column(name="SYSTOLIC")
	private Integer systolic;
	
	@Column(name="USER_PROFILE_USER_PROFILE_ID")
	private Long userprofileId;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Integer getDiastolic() {
		return diastolic;
	}

	public void setDiastolic(Integer diastolic) {
		this.diastolic = diastolic;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public Date getReading() {
		return reading;
	}

	public void setReading(Date reading) {
		this.reading = reading;
	}

	public Integer getSystolic() {
		return systolic;
	}

	public void setSystolic(Integer systolic) {
		this.systolic = systolic;
	}

	public Long getUserprofileId() {
		return userprofileId;
	}

	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

}
